<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
    */

    include "../include/includeBaseComponenti.php";
    include "../../../template/stile.php";
    
    if(isset($_GET["id"])) {
        $elemento       = $geecomDb->leggiSingolaRiga("geec_elementiContatore",filter_input(INPUT_GET,"id",FILTER_SANITIZE_NUMBER_INT));
        $datiOccorrenza = $geecomDb->leggiSingolaRiga("geec_contatori",$elemento["idContatore"]);
    }
    
    $arrayDimensioniIcona = array("fa-2x"=>"2x","fa-3x"=>"3x","fa-5x"=>"5x","fa-7x"=>"7x","fa-10x"=>"10x");
    $arrayColori          = array("Primary","Secondary","Info","Light","Dark","Warning","Danger");
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

        <?php
            include "../include/cssBaseComponenti.php";
        ?>
        <title>Geecom CMS - Creazione elemento</title>
    </head>
    <body>
    
        <header>
            <?php 
                include "../../include/barraSuperiore.php";

                include "../../include/header.php";

                include "../../include/barraMenu.php";
            ?>
        </header>
	
        <main role="main" class="bg-light" id="main">
            <div class="container-fluid">

                <?php 
                    if(isset($_GET["status"])) {
                        $status = filter_input(INPUT_GET,"status",FILTER_SANITIZE_NUMBER_INT);
                    }
                    else {
                        $status = 0;
                    }

                ?>
                    <div class="row py-4">
                        <?php 
                            if($status==200) {
                                echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento modificato
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                            else if($status==210) {
                                 echo"<div class=\"col-12\">
                                        <div class=\"alert alert-success alert-dismissible fade show\" role=\"alert\">
                                            Elemento duplicato, modificalo per non avere due elementi uguali
                                            <button type=\"button\" class=\"close\" data-dismiss=\"alert\" aria-label=\"Close\">
                                                  <span aria-hidden=\"true\">&times;</span>
                                            </button>
                                        </div>
                                    </div>";
                            }
                        ?>
                        
                        <div class="col-12">
                            <div class="form-row justify-content-between mb-3">
                                <div class="col-auto d-flex">
                                    <nav aria-label="breadcrumb" class="align-self-center">
                                        <ol class="breadcrumb p-0 mb-1 mb-md-0 bg-transparent">
                                            <li class="breadcrumb-item"><a href="../../home.php">Home</a></li>
                                            <li class="breadcrumb-item"><a href="#" data-toggle="modal" data-target="#menu-componenti">Componenti</a></li>
                                            <li class="breadcrumb-item"><a href="index.php">Contatori</a></li>
                                            <li class="breadcrumb-item"><a href="creaContatore.php?id=<?php echo $datiOccorrenza["id"] ?>"><?php echo $datiOccorrenza["nome"] ?></a></li>
                                            <li class="breadcrumb-item active" aria-current="page"><?php echo((isset($elemento)? $elemento["etichetta"] : "Nuovo elemento"))?></li>
                                        </ol>
                                    </nav>
                                </div>
                                <div class="col-auto text-right">
                                    <a class="btn btn-outline-primary" href="creaContatore.php?id=<?php echo $datiOccorrenza["id"] ?>"><i class="fas fa-arrow-left mr-2"></i>Torna all'elenco</a>
                                    <button class="btn btn-primary" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    <button type="button" class="btn btn-warning mt-2 mt-lg-0" onclick="location.href='controller/controllerComponente.php?id=<?php echo $elemento["idContatore"] ?>&operazione=duplicaElemento&idElemento=<?php echo $elemento["id"] ?>';"><i class="far fa-clone mr-2"></i>Duplica</button>
                                </div>
                            </div>
                            <div class="card mb-4 box-shadow-lite">
                                <form name="formComponente" action="controller/controllerComponente.php" method="post">
                                    
                                    <input type="text" class="d-none" name="operazione" value="modificaElemento">
                                    <input type="text" class="d-none" name="id" value="<?php echo((isset($elemento) ? $elemento["idContatore"] : "0")); ?>">
                                    <input type="text" class="d-none" name="idElemento" value="<?php echo((isset($elemento) ? $elemento["id"] : "0")); ?>">

                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-lg-12">
                                                <div class="row">
                                                    <div class="form-group col-md-6">
                                                        <label>Etichetta:</label>
                                                        <input type="text" class="form-control" id="nomeSlider" name="etichetta" aria-describedby="etichetta" value="<?php echo((isset($elemento) ? $elemento["etichetta"] : "")) ?>" placeholder="Etichetta">
                                                    </div>
                                                    
                                                    <div class="form-group col-md-4">
                                                        <label>Valore</label>
                                                        <input type="text" class="form-control" name="valore" value="<?php echo $elemento["valore"] ?>">
                                                    </div>
                                                    
                                                    <div class="form-group col-md-4">
                                                        <label for="titolo-articolo">Icona</label>
                                                        <input type="text" class="form-control" name="icona" value="<?php echo $elemento["icona"] ?>">
                                                    </div>
                                                    
                                                    <div class="form-group col-md-4">
                                                        <label for="titolo-articolo">Dimensione icona</label>
                                                        <select class="form-control" name="dimensioneIcona">
                                                        <?php 
                                                            foreach($arrayDimensioniIcona as $dimensione) {
                                                                if($elemento["dimensioneIcona"]==$dimensione) {
                                                                    echo"<option value=\"$dimensione\" selected>$dimensione</option>";
                                                                }
                                                                else {                                                            
                                                                    echo"<option value=\"$dimensione\">$dimensione</option>";
                                                                }
                                                            }
                                                        ?> 
                                                        </select>
                                                    </div>
                                                    
                                                    <div class="form-group col-md-4">
                                                        <label for="titolo-articolo">Colore</label>
                                                        <select class="form-control" name="colore">
                                                            <option value="">Nessuno</option>
                                                            <?php 
                                                                foreach($arrayColori as $colore) {
                                                                    if($elemento["colore"]==$colore) {
                                                                        echo"<option value=\"$colore\"  selected>$colore</option>";
                                                                    }
                                                                    else {                                                            
                                                                        echo"<option value=\"$colore\">$colore</option>";
                                                                    }
                                                                }
                                                            ?> 
                                                        </select>
                                                    </div>

                                                </div>   
                                            </div><!--/Colonna principale -->
                                        </form>
                                        </div>
                                    </div>
                                    <div class="card-footer">
                                        <button type="button" class="btn btn-primary float-right" onclick="document.formComponente.submit()"><i class="fas fa-check"></i> Salva</button>
                                    </div>
                                </div>
                            </div>
                        
                            </div>
                        </div>
           
                    </form>
                </div>
            </div>
        </main>

        <?php 
            include "../../include/footer.php";

            include "../include/modal/cambiaPassword.php";

            include "../../include/modal/modalMenuComponenti.php";

            include "../../include/modal/operazioneCompletata.php";

            include "../include/jsBaseComponenti.php";
        ?>
        
        <!-- Dropzone -->
        <script type="text/javascript" src="../../../plugins/dropzone/dropzone.js"></script>
        <script>
            $("#frmFileUpload-00").dropzone({
                acceptedFiles: ".jpeg,.jpg,.png,.gif,.svg",
                maxFiles: 1,
                addRemoveLinks: true,
                dictRemoveFile: "Rimuovi",
                success: function(file,response) {
                    document.getElementById("immagineElemento").src=response;
                    this.removeAllFiles();
                },
                params:{
                    operazione:"modificaImmagineElemento",
                    idElemento:<?php echo $elemento["id"] ?>
                },
                maxfilesexceeded: function(file) {
                    this.removeAllFiles();
                    this.addFile(file);
                }
            })
        </script>

    </body>
</html>
